<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Enquiry; 
use Mail;

class EnquiryController extends Controller
{
    //
    public function saveEnquiryAndSendEmail(Request $request) { 
        $this->validate($request, [
            'company_name' => 'required',
            'name' => 'required',
            'email' => 'required|email',
            'phone_number' => 'required',
            'requirements' => 'required'
        ]);

        /*
        $enquiry = new Enquiry;

        $enquiry->company_name = $request->company_name;
        $enquiry->name = $request->name;
        $enquiry->email = $request->email;
        $enquiry->phone_number = $request->phone_number;
        $enquiry->requirements = $request->requirements;

        $enquiry->save();

        Mail::send('templates/enquiry-email',
        	array(
        		'company_name' => $request->get('company_name'),
        		'name' => $request->get('name'),
        		'email' => $request->get('email'),
        		'phone_number' => $request->get('phone_number'),
        		'requirements' => $request->get('requirements'),
        	), function($message) use ($request)
        	{
        		$sub = "Received inquiry from ". $request->get('company_name');
        		$message->subject($sub);
        		$message->from($request->email);
        		$message->to('info@kohinoorinternational.in');
        	}
        ); */

        return back()->with(['success_title' => 'Thank you for your enquiry.', "success_msg" => 'Your message has been sent successfully.']);

    }
}
