@extends('layouts.main_layout')
@section('page-title', 'Contact Us')
@section('meta-desp', 'Contact - Hydro X (+91-983-860-0270)')
@section('meta-keywords', 'contact Hydro X, Hydro X, about Hydro X, contact-us, Water Treatment')

@section('internal-css')
    
@endsection

@section('content')
    <!-- start page title section -->
    <section class="page-title-section bg-img cover-background" data-overlay-dark="65" data-background="img/bg/page-title.jpg">
        <div class="container">

            <div class="row">
                <div class="col-md-12">
                    <h1>Contact Us</h1>
                </div>
                <div class="col-md-12">
                    <ul>
                        <li><a href="index.html">Home</a></li>
                        <li><a href="javascript:void(0)">Contact Us</a></li>
                    </ul>
                </div>
            </div>

        </div>
    </section>
    <!-- end page title section -->

    <!-- start contact section -->
    <section class="bg-grey">
        <div class="container">
            <div class="row">
                <div class="col">
                    @if(Session::has('success'))
                        <div class="alert alert-success">
                            {{ Session::get('success') }}
                        </div>
                    @endif
                </div>
            </div>
            <div class="row">
                <div class="col-lg-4 mb-4 mb-lg-0">
                    <div class="card card-style07 py-2-8 px-1-6 bg-white wow fadeInUp" data-wow-delay=".2s">
                        <div class="card-body">
                            <div class="title-box mb-4">
                                <i class="fas fa-map-marker-alt"></i>
                                <div class="box-circle-large"></div>
                                <div class="box-circle-small"></div>
                            </div>
                            <h3 class="h5 mb-3">Visit Our Office</h3>
                            <p class="mb-0 w-90 w-md-75 w-lg-100 mx-auto">
                                <span class="font-weight-600">
                                    <b><span style="color: #f8821e">Hydro-X </span> <span style="color: #00aeef">Water Treatment</span></b>
                                </span> <br>
                                B 97 NOIDA SECTOR 64,  <br>
                                Gautam Buddha Nagar - 201301, Uttar Pradesh, India <br>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 mb-4 mb-lg-0">
                    <div class="card card-style07 py-2-8 px-1-6 bg-white wow fadeInUp" data-wow-delay=".4s">
                        <div class="card-body">
                            <div class="title-box mb-4">
                                <i class="fas fa-comments"></i>
                                <div class="box-circle-large"></div>
                                <div class="box-circle-small"></div>
                            </div>
                            <h3 class="h5 mb-3">Let's Talk</h3>
                            <p class="mb-0 w-90 w-md-75 w-lg-100 mx-auto"><strong class="font-weight-600">Mobile:</strong> <a href="tel:+91-983-860-0270">+91-983-860-0270</a></p>
                            <p class="mb-0 w-90 w-md-75 w-lg-100 mx-auto"><strong class="font-weight-600">Whatsapp: </strong><a href="https://api.whatsapp.com/send?phone=919838600270&text=Hello%20Hydro-X%20Water%20Treatment">+91-9838600270</a></p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="card card-style07 py-2-8 px-1-6 bg-white wow fadeInUp" data-wow-delay=".6s">
                        <div class="card-body">
                            <div class="title-box mb-4">
                                <i class="fas fa-envelope"></i>
                                <div class="box-circle-large"></div>
                                <div class="box-circle-small"></div>
                            </div>
                            <h3 class="h5 mb-3">E-mail Us</h3>
                            <p class="mb-0 w-90 w-md-75 w-lg-100 mx-auto"><a href="mailto:contact@hydroxwatertreatment.com">contact@hydroxwatertreatment.com</a></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- end contact section -->

    <!-- start contact form -->
    <section>
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-12 col-lg-10 wow fadeIn">

                    <div class="w-md-85 w-xl-65 text-center mx-auto mb-6 mb-lg-8">
                        <h2 class="mb-4">Get in Touch</h2>
                        <p class="mx-auto mb-0">We are available 24/7 by e-mail and phone. You can also ask a question about our services through our contact form.</p>
                    </div>

                    <!-- start form here -->
                    <form class="quform" action="{{ route('contact-us') }}" method="post" enctype="multipart/form-data">
                        {{csrf_field()}}
                        <div class="quform-elements">

                            <div class="form-row">

                                <!-- Begin Text input element -->
                                <div class="col-md-6">
                                    <div class="quform-element form-group">
                                        <div class="quform-input">
                                            <input class="form-control @error('name') is-invalid @enderror" required="" id="name" type="text" name="name" placeholder="Your name here" />
                                            @error('name')
                                               <span class="invalid-feedback" role="alert">
                                                   <strong>{{ $message }}</strong>
                                               </span>
                                           @enderror
                                        </div>
                                    </div>

                                </div>
                                <!-- End Text input element -->

                                <!-- Begin Text input element -->
                                <div class="col-md-6">
                                    <div class="quform-element form-group">
                                        <div class="quform-input">
                                            <input class="form-control  @error('email') is-invalid @enderror" required="" type="email" name="email" placeholder="Your email here" />
                                            @error('email')
                                               <span class="invalid-feedback" role="alert">
                                                   <strong>{{ $message }}</strong>
                                               </span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                                <!-- End Text input element -->

                                <!-- Begin Text input element -->
                                <div class="col-md-6">
                                    <div class="quform-element form-group">
                                        <div class="quform-input">
                                            <input class="form-control @error('subject') is-invalid @enderror" required="" type="text" name="subject" placeholder="Your subject here" />
                                            @error('subject')
                                               <span class="invalid-feedback" role="alert">
                                                   <strong>{{ $message }}</strong>
                                               </span>
                                           @enderror
                                        </div>
                                    </div>

                                </div>
                                <!-- End Text input element -->

                                <!-- Begin Text input element -->
                                <div class="col-md-6">
                                    <div class="quform-element form-group">
                                        <div class="quform-input">
                                            <input class="form-control @error('phone_number') is-invalid @enderror" required="" id="phone" type="text" name="phone_number" placeholder="Your phone number" />
                                            @error('phone_number')
                                               <span class="invalid-feedback" role="alert">
                                                   <strong>{{ $message }}</strong>
                                               </span>
                                           @enderror
                                        </div>
                                    </div>

                                </div>
                                <!-- End Text input element -->

                                <!-- Begin Textarea element -->
                                <div class="col-md-12">
                                    <div class="quform-element form-group">
                                        <div class="quform-input">
                                            <textarea class="form-control textarea @error('message') is-invalid @enderror" required="" id="message" name="message" rows="4" placeholder="Tell us a few words"></textarea>
                                            @error('message')
                                               <span class="invalid-feedback" role="alert">
                                                   <strong>{{ $message }}</strong>
                                               </span>
                                           @enderror
                                        </div>
                                    </div>
                                </div>
                                <!-- End Textarea element -->

                                <!-- Begin Submit button -->
                                <div class="col-md-12">
                                    <div class="quform-submit-inner">
                                        <button class="butn style-one fill" type="submit"><span>Submit</span></button>
                                    </div>
                                    <div class="quform-loading-wrap text-left"><span class="quform-loading"></span></div>
                                </div>
                                <!-- End Submit button -->

                            </div>

                        </div>

                    </form>
                    <!-- end form here -->

                </div>
            </div>
        </div>
    </section>
    <!-- end contact form -->

    <!-- start map section -->
    <iframe class="contact-map" id="gmap_canvas" src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d14017.313308159718!2d77.3736512!3d28.611892!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x390ce501c4f7387b%3A0xcf3f43f6d16fb7c9!2sHydro-X%20Water%20Treatment%20Pvt.%20Ltd.!5e0!3m2!1sen!2sin!4v1721049748122!5m2!1sen!2sin" scrolling="no" marginheight="0" marginwidth="0"></iframe>

    <!-- end map section -->

     <!-- TESTIMONIALS
        ================================================== -->
    <section class="md">

        <div class="container lg-container">

            <div class="section-title text-center mb-3 mb-lg-5 wow fadeInDown" data-wow-delay=".2s">
                <h2 class="font-weight-700 mb-3">What our client say</h2>
                <p class="w-95 w-md-80 w-lg-60 w-xl-45 mx-auto">Success speaks for itself. See how our clients describe the difference we’ve made in their journey</p>
            </div>

        </div>

        <div class="container">

            <div class="owl-carousel owl-theme testmonial-style03 wow fadeInUp" data-wow-delay=".2s">
                <div class="testmonial-block3">
                    <div class="pb-4 bg-white">
                        <span class="alt-font quote">“</span>
                        <p>Our business flourished with Hydro X Water Treatments Industrial RO Plant. Crystal-clear water, unmatched purity! A game-changer for our operations. Kudos to the Hydro X team!</p>
                    </div>
                    <div class="d-flex align-items-center">
                        <div class="me-3">
                            <img class="img-fluid rounded-circle" style="height: 40px" src="{{ asset('/img/avatar/male.png') }}" alt="...">
                        </div>
                        <div>
                            <h6 class="mb-0 ml-2">Shashank Shekhar</h6>
                        </div>
                    </div>
                </div>
                <div class="testmonial-block3">
                    <div class="pb-4 bg-white">
                        <span class="alt-font quote">“</span>
                        <p>Transformative health journey with the Enagic Kangen Machine from Hydro X Water Treatment. Energizing alkaline water, rejuvenating every cell. Grateful for the positive impact on our well-being.</p>
                    </div>
                    <div class="d-flex align-items-center">
                        <div class="me-3">
                            <img class="img-fluid rounded-circle" style="height: 40px" src="{{ asset('/img/avatar/female.png') }}" alt="...">
                        </div>
                        <div>
                            <h6 class="mb-0 ml-2">Anshika Sharma</h6>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- start extra section -->
    <section class="p-0 wow fadeInUp position-relative z-index-9 bg-transparent" data-wow-delay=".2s">
        <div class="container lg-container">
            <div class="parallax cover-background p-2-2 p-lg-8 p-xl-10 wow fadeInUp theme-overlay-90 rounded" data-overlay-dark="9" data-background="img/bg/footer-bg.jpg">
                <div class="row position-relative z-index-1 align-items-center">
                    <div class="col-lg-7 text-center text-lg-left mb-3 mb-lg-0"><h5 class="text-white">Get in Touch on Whatsapp</h5></div>
                    <div class="col-lg-5 text-center text-lg-right"><a href="https://api.whatsapp.com/send?phone=919838600270&text=Hello" class="butn style-two">
                        <span><i class="fab fa-whatsapp"></i>&nbsp;&nbsp;Let's Chat</span>
                    </a></div>
                </div>
            </div>
        </div>
    </section>
    <!-- end extra section -->

@endsection