@extends('layouts.main_layout')
@section('page-title', 'Service & Support | Hydro X')
@section('meta-desp', 'Hydro X Service & Support - Water treatment solutions including mineral water plants, RO systems, and sewage treatment. Contact us for enquiries.')
@section('meta-keywords', 'enquiry, contact Hydro X, Hydro X, about Hydro X, contact-us')

@section('internal-css')
    <style>
    	.my-list li {
    		margin-bottom: 15px !important;
    	}
    </style>
@endsection

@section('content')

    <!-- start page title section -->
    <section class="page-title-section bg-img cover-background" data-overlay-dark="65" data-background="{{ asset('/img/bg/bg-01.jpg') }}">
        <div class="container">

            <div class="row">
                <div class="col-md-12">
                    <h1>Service & Support</h1>
                </div>
                <div class="col-md-12">
                    <ul>
                        <li><a href="/">Home</a></li>
                        <li><a href="javascript:void(0)">Service & Support</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </section>
    <!-- end page title section -->

     <!-- SERVICE DETAILS
        ================================================== -->
    <section>
        <div class="container">
            <div class="row">

                <!-- blog left -->
                <div class="col-lg-8 col-md-12 mb-5 mb-lg-0">
                    <div class="pe-lg-5">
                        <div class="mb-5 bg-white p-4 rounded box-shadow-primary">
                            <img src="{{ asset('/img/content/banner-content.jpg') }}" class="rounded" alt="...">
                        </div>
                        <div class="row mb-5">
                            <div class="col">
                                <span class="icon-circle green mb-4"><span class="text">01</span></span>
                                <h3 class="text-color-md-blue mb-4">Installation & Commissioning</h3>
                                <p>We don’t just sell products; we ensure they start right. Our expert technicians handle the complete installation and commissioning of Industrial RO, STP, and ETP plants, ensuring your system is calibrated for maximum efficiency from day one.</p>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col">
                                <span class="icon-circle orange mb-4"><span class="text">02</span></span>
                                <h3 class="text-color-md-blue mb-4">Annual Maintenance Contracts (AMC)</h3>
                                <p>Prevent downtime before it happens. Our comprehensive AMC packages provide regular check-ups, preventive maintenance, and priority support to keep your plant running smoothly year-round.</p>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col">
                                <span class="icon-circle blue mb-4"><span class="text">03</span></span>
                                <h3 class="text-color-md-blue mb-4">Operation & Maintenance (O&M)</h3>
                                <p>Focus on your core business while we handle your water management. We offer dedicated O&M services where our trained manpower operates your plant 24/7, ensuring strict adherence to environmental standards.</p>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col">
                                <span class="icon-circle yellow mb-4"><span class="text">04</span></span>
                                <h3 class="text-color-md-blue mb-4">Plant Upgradation & Revamping</h3>
                                <p>Is your existing plant underperforming or outdated? We analyze your current infrastructure and provide cost-effective retrofitting and revamping solutions to boost capacity and quality without the need for a full replacement.</p>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col">
                                <span class="icon-circle green mb-4"><span class="text">05</span></span>
                                <h3 class="text-color-md-blue mb-4">Genuine Spares & Consumables</h3>
                                <p>We supply high-quality, genuine spare parts—from membranes and pumps to chemicals and dosing systems—ensuring compatibility and durability for your machinery.</p>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- end blog left -->

                <!-- right panel -->
                <div class="col-lg-4 col-md-12">

                    <div class="widget-block">
                        <h4>Company Factsheet</h4>
                        <ul class="list-style-icon ps-0">
                            <li>
                                <i class="fas fa-globe"></i>
                                <h6>Nature of Business</h6>
                                <p>Manufacturer, Supplier & Exporter</p>
                            </li>
                            <li>
                                <i class="fas fa-building"></i>
                                <h6>Year of Establishment</h6>
                                <p>2016</p>
                            </li>
                            <li>
                                <i class="fas fa-balance-scale"></i>
                                <h6>Legal Status of Firm</h6>
                                <p>Private Limited</p>
                            </li>
                            <li>
                                <i class="fas fa-file-invoice"></i>
                                <h6>GST Number</h6>
                                <p>09AAECH0061M1ZJ</p>
                            </li>
                            <li>
                                <i class="fas fa-map-marker-alt"></i>
                                <h6>Location</h6>
                                <p>Uttar Pradesh, India</p>
                            </li>
                        </ul>

                    </div>

                    <div class="widget-block">
                        <h4>Need Help?</h4>
                        <ul class="list-style-icon ps-0">
                            <li>
                                <i class="fas fa-map-marker-alt"></i>
                                <p>B 97 NOIDA SECTOR 64, Gautam Buddha Nagar - 201301, Uttar Pradesh, India</p>
                            </li>
                            <li>
                                <i class="fas fa-phone"></i>
                                <p>(+91) 9838600270</p>
                            </li>
                            <li>
                                <i class="fas fa-envelope"></i>
                                <p>contact@hydroxwatertreatment.com</p>
                            </li>
                        </ul>

                    </div>

                </div>
                <!-- end right panel -->

            </div>
        </div>
    </section>



    <!-- start contact section -->
    <section class="p-0">
        <div class="container lg-container">
            <div class="parallax text-center cover-background p-2-0 p-sm-2-8 p-lg-8 p-xl-10 wow fadeInUp theme-overlay-180 rounded z-index-9" data-wow-delay=".2s" data-overlay-dark="9" data-background="img/bg/footer-bg.jpg">

                <div class="position-relative z-index-1">
                    <h4 class="mb-4 text-white">We’re Just a Message Away</h4>
                    <p class="w-95 w-md-80 w-lg-65 w-xl-50 mx-auto text-white mb-4">We’re here to help you with safe, efficient, and eco-friendly treatment</p>
                    <a href="https://api.whatsapp.com/send?phone=919838600270&text=Hello" class="butn style-two">
                        <span><i class="fab fa-whatsapp"></i>&nbsp;&nbsp;Let's Chat</span>
                    </a>
                </div>

            </div>
        </div>
    </section>
    <!-- end contact section -->

@endsection
