<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\EnquiryController;


use App\Http\Controllers\ProductController;
use App\Http\Controllers\InvoiceController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\CustomerController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::get('/email', function(){
	return view('templates/enquiry-email', [
            'company_name' => 'PrinceTech',
            'name' => 'Vikram Kumar',
            'email' => 'vikram@gmail.com',
            'phone_number' => '12345678901',
            'requirements' => 'Here is where you can register web routes for your application. These routes are loaded by the RouteServiceProvider within a group which contains the "web" middleware group. Now create something great!'
	]);
});

Route::view('/contact', 'contact');
Route::post('contact-us', [ContactController::class, 'saveContact'])->name('contact-us');
Route::post('enquiry', [EnquiryController::class, 'saveEnquiryAndSendEmail'])->name('enquiry');

Route::view('/about', 'about');
Route::view('/enquiry', 'enquiry');
Route::view('/service-support', 'service-support');
Route::view('/test', 'test');

require __DIR__.'/auth.php';