<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<meta name="author" content="Vikram Kumar" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="keywords" content="<?php echo $__env->yieldContent('meta-keywords'); ?>" />
    <meta name="description" content="<?php echo $__env->yieldContent('meta-desp'); ?>" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('page-title'); ?></title>
	
    <!-- favicon -->
    <!-- favicon -->
    <link rel="icon" href="<?php echo e(asset('/img/logos/favicon.png')); ?>" />

    <link rel="apple-touch-icon" sizes="72x72" href="<?php echo e(asset('/img/logos/apple-icon-72x72.png')); ?>">

    <link rel="apple-touch-icon" sizes="114x114" href="<?php echo e(asset('/img/logos/apple-icon-114x114.png')); ?>">

    <!-- plugins -->
    <link rel="stylesheet" href="<?php echo e(asset('/css/plugins.css')); ?>" />

    <!-- theme core css -->
    <link href="<?php echo e(asset('/css/styles.css')); ?>" rel="stylesheet" id="colors">
    <?php $__env->startSection('internal-css'); ?>
    <?php echo $__env->yieldSection(); ?>

    <style>
        .list-style li a.activelink {
            color: #f8821e;
            font-weight: 600;
        }

    	@media (max-width: 991px){
	    	.bgcolor-white {
	    		background: #FFF;
	    	}
	    }
    </style>

</head>
<body>

	<!-- start main-wrapper section -->
    <div class="main-wrapper">
    	<!-- start header section -->
        <header class="position-absolute w-100 transparent-header sm-position-relative" id="header" style="background: rgba(0,0,0,0.3);">

            <div class="navbar-default bgcolor-white">
                <div class="container1 lg-container pl-md-5 pr-md-5 pl-3 pr-3">
                    <div class="row align-items-center">
                        <div class="col-12">
                            <div class="menu_area alt-font">
                                <nav class="navbar navbar-expand-lg navbar-light p-0">

                                    <div class="navbar-header navbar-header-custom" style="padding: 0px;">
                                        <!-- start logo -->
                                        <a href="<?php echo e(url('/')); ?>" class="navbar-brand inner-logo">
                                        	<table>
                                        		<tr>
                                        			<td>
                                        				
                                        			<img id="logo" src="<?php echo e(asset('/img/logos/rm_logo_white.png')); ?>" alt="logo" style="max-height: 72px !important; border-radius: 10px;">
                                        			</td>
                                        			<td>
                                        				<h5 style="color: #f8821e; margin-left: 10px; margin-top: 5px;">
                                        					<b>KOHINOOR</b>
                                        				</h5>
                                        				<h5 style="color: #00aeef; margin-left: 10px; margin-top: -5px;">
                                        					<b>INTERNATIONAL</b>
                                        				</h5>
                                        				</b>
                                        			</td>
                                        		</tr>
                                        	</table>
                                        </a>
                                        <!-- end logo -->
                                    </div>

                                    <div class="navbar-toggler"></div>

                                    <!-- start menu area -->
                                    <ul class="navbar-nav ml-auto" id="nav" style="display: none;">
                                        <li><a href="<?php echo e(url('/')); ?>">Home</a></li>
                                        <li><a href="<?php echo e(url('/about')); ?>">About Us</a></li>
                                        <li><a href="javascript:void(0)">Products</a>
                                            <ul>
                                                <li><a href="<?php echo e(url('/products/stainless-steel-buttweld-fittings')); ?>">Stainless Steel Fittings</a></li>
                                                <li><a href="<?php echo e(url('/products/stainless-steel-flanges')); ?>">Stainless Steel Flanges</a></li>
                                                <li><a href="javascript:void(0)">SCRAP</a>
                                                    <ul>
                                                        <li><a href="<?php echo e(url('/products/scrap/stainless-steel-scrap')); ?>">Stainless Steel Scrap</a></li>
                                                        <li><a href="<?php echo e(url('/products/scrap/inconel-scrap')); ?>">Inconel Scrap</a></li>
                                                        <li><a href="<?php echo e(url('/products/scrap/monel-scrap')); ?>">Monel Scrap</a></li>
                                                        <li><a href="<?php echo e(url('/products/scrap/duplex-scrap')); ?>">Duplex Scrap</a></li>
                                                        <li><a href="<?php echo e(url('/products/scrap/hastalloy-scrap')); ?>">Hastalloy Scrap</a></li>
                                                        <li><a href="<?php echo e(url('/products/scrap/hrcs-scrap')); ?>">HRCS Scrap</a></li>
                                                    </ul>
                                                </li>
                                            </ul>
                                        </li>
                                        
                                        <li><a href="<?php echo e(url('/quality-policy')); ?>">Quality Policy</a></li>
                                        <li><a href="<?php echo e(url('/contact')); ?>">Contact Us</a></li>
                                    </ul>
                                    <!-- end menu area -->
                                    <div class="ml-4 d-none d-lg-inline-block">
                                        <a class="butn style-four small" href="<?php echo e(url('/enquiry')); ?>">Enquiry</a>
                                    </div>

                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </header>
        <!-- end header section -->

        <?php $__env->startSection('content'); ?>
        <?php echo $__env->yieldSection(); ?>

        <!-- start footer section -->
        <footer class="footer-style3 bg-white bg-img cover-background" data-background="<?php echo e(asset('/img/bg/footer.png')); ?>">
            <div class="container lg-container">
                <div class="footer-5">
                    <div class="row">
                        <div class="col">
                            <span class="footer-logo mb-1-6 d-inline-block">
                                <table>
                                    <tr>
                                        <td>
                                            
                                        <img id="logo" src="<?php echo e(asset('/img/logos/rm_logo_white.png')); ?>" alt="logo" style="max-height: 72px !important; border-radius: 10px;">
                                        </td>
                                        <td>
                                            <h5 style="color: #f8821e; margin-left: 12px; margin-top: 5px;">
                                                <b>KOHINOOR</b>
                                            </h5>
                                            <h5 style="color: #00aeef; margin-left: 12px; margin-top: -5px;">
                                                <b>INTERNATIONAL</b>
                                            </h5>
                                            </b>
                                        </td>
                                    </tr>
                                </table>
                            </span>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-4 col-md-6 mb-5 mb-lg-0">
                            <div style="padding: 15px; box-shadow: 0rem 0rem 0.5rem rgb(255 255 255) !important; margin-bottom: 20px; border-radius: 5px;">
                                <span>
                                    <b style="color: #dee1e0">GSTIN: &nbsp;</b>
                                    27AAAFZ9048H1ZR
                                </span> <br />
                                <b><span style="color: #f8821e">KOHINOOR</span> <span style="color: #00aeef">INTERNATIONAL</span></b><br>
                                <span style="color: #ffc107; font-weight: 500;">FORMERLY M/s ZENOTECH ALLOYS INDUSTRIES</span>
                            </div>
                            <p>
                                OFFICE NO. 5, 1st FLOOR, 110/112, <br>
                                SRIRAM SADAN BLDG, 3RD KUMBHARWADA LANE, <br />
                                MUMBAI 400004 MAHARASHTRA, INDIA <br><br>
                            </p>
                        </div>

                        <div class="col-lg-4 pl-lg-5 col-md-6 mb-5 mb-lg-0">
                        	<h3>Contact</h3>
                            <span class="font-weight-700 text-white">MR. PIYUSH MODI</span>
                            <ul>
                                <li><a href="mailto:info@kohinoorinternational.in">info@kohinoorinternational.in</a></li>
                                <li><a href="tel:+919982512470">+91 9982512470</a></li>
                                <li><a href="tel:+917665120417">+91 7665120417</a></li>
                            </ul>
                            <div class="footer-icon">
                                <ul class="mb-0">
                                    <li>
                                        <a href="#!"><i class="fab fa-facebook-f"></i></a>
                                    </li>
                                    <li>
                                        <a href="#!"><i class="fab fa-twitter"></i></a>
                                    </li>
                                    <li>
                                        <a href="#!"><i class="fab fa-dribbble"></i></a>
                                    </li>
                                    <li>
                                        <a href="#!"><i class="fab fa-linkedin-in"></i></a>
                                    </li>
                                </ul>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-6 mb-5 mb-md-0">
                            <h3>Our Products</h3>
                            <ul class="mb-0">
                                <li><a href="<?php echo e(url('/products/stainless-steel-buttweld-fittings')); ?>">Stainless Steel Fitting</a></li>
                                <li><a href="<?php echo e(url('/products/stainless-steel-flanges')); ?>">Stainless Steel Flanges</a></li>
                                <li><a href="#!">Stainless Steel Fasteners</a></li>
                                <li><a href="#!">Stainless Steel Sheet</a></li>
                                <li><a href="#!">Stainless Steel Pipe</a></li>
                                <li><a href="#!">Stainless Steel Round Bar</a></li>

                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <div class="footer-style3-bottom mt-3">
                <div class="container">
                    <p>&copy;
                        <script>
                            document.write(new Date().getFullYear())
                        </script> Copyright | Design and developed by<a href="http://vikramkumar.in" target="_blank" class="font-weight-700"> Vikram</a></p>
                </div>
            </div>
        </footer>
        <!-- end footer section -->

    </div>
    <!-- end main-wrapper section -->
	

	<!-- start scroll to top -->
    <a href="javascript:void(0)" class="scroll-to-top"><i class="fas fa-angle-up" aria-hidden="true"></i></a>
    <!-- end scroll to top -->

    <!-- all js include start -->
    <script type="text/javascript" src="<?php echo e(asset('/img/slider/engine1/wowslider.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('/img/slider/engine1/script.js')); ?>"></script>

    <!-- jquery -->
    <script src="<?php echo e(asset('/js/core.min.js')); ?>"></script>

    <!-- custom scripts -->
    <script src="<?php echo e(asset('/js/main.js')); ?>"></script>
    <!-- all js include end -->
    
    <script type="module">
      // Import the functions you need from the SDKs you need
      import { initializeApp } from "https://www.gstatic.com/firebasejs/9.1.3/firebase-app.js";
      import { getAnalytics } from "https://www.gstatic.com/firebasejs/9.1.3/firebase-analytics.js";
      // TODO: Add SDKs for Firebase products that you want to use
      // https://firebase.google.com/docs/web/setup#available-libraries

      // Your web app's Firebase configuration
      // For Firebase JS SDK v7.20.0 and later, measurementId is optional
      const firebaseConfig = {
        apiKey: "AIzaSyD7MQc3548mr_RLfWeQzwHJP_SrXUoNb7s",
        authDomain: "kohinoor-international.firebaseapp.com",
        projectId: "kohinoor-international",
        storageBucket: "kohinoor-international.appspot.com",
        messagingSenderId: "224641455802",
        appId: "1:224641455802:web:bcfea722b52ff8f4829483",
        measurementId: "G-60HJZHWRET"
      };

      // Initialize Firebase
      const app = initializeApp(firebaseConfig);
      const analytics = getAnalytics(app);
    </script>
</body>
</html><?php /**PATH /home/h5trcel3csho/public_html/resources/views/layouts/main_layout.blade.php ENDPATH**/ ?>