<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<meta name="author" content="Vikram Kumar" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="keywords" content="<?php echo $__env->yieldContent('meta-keywords'); ?>" />
    <meta name="description" content="<?php echo $__env->yieldContent('meta-desp'); ?>" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('page-title'); ?> | Rehan Metals</title>
	
    <!-- favicon -->
    <!-- favicon -->
    <link rel="icon" href="<?php echo e(asset('/img/logos/favicon.png')); ?>" />

    <link rel="apple-touch-icon" sizes="72x72" href="<?php echo e(asset('/img/logos/apple-icon-72x72.png')); ?>">

    <link rel="apple-touch-icon" sizes="114x114" href="<?php echo e(asset('/img/logos/apple-icon-114x114.png')); ?>">

    <!-- plugins -->
    <link rel="stylesheet" href="<?php echo e(asset('/css/plugins.css')); ?>" />

    <!-- theme core css -->
    <link href="<?php echo e(asset('/css/styles.css')); ?>" rel="stylesheet" id="colors">
    <?php $__env->startSection('internal-css'); ?>
    <?php echo $__env->yieldSection(); ?>

</head>
<body>

	<!-- start main-wrapper section -->
    <div class="main-wrapper">
    	<!-- start header section -->
        <header class="position-absolute w-100 transparent-header sm-position-relative" id="header" style="background: rgba(0,0,0,0.3);">

            <div class="navbar-default">
                <div class="container lg-container">
                    <div class="row align-items-center">
                        <div class="col-12">
                            <div class="menu_area alt-font">
                                <nav class="navbar navbar-expand-lg navbar-light p-0">

                                    <div class="navbar-header navbar-header-custom">
                                        <!-- start logo -->
                                        <a href="/" class="navbar-brand inner-logo"><img id="logo" src="<?php echo e(asset('/img/logos/rm_logo_white.png')); ?>" alt="logo"></a>
                                        <!-- end logo -->
                                    </div>

                                    <div class="navbar-toggler"></div>

                                    <!-- start menu area -->
                                    <ul class="navbar-nav ml-auto" id="nav" style="display: none;">
                                        <li><a href="/">Home</a></li>
                                        <li><a href="/about">About Us</a></li>
                                        <li><a href="javascript:void(0)">Products</a>
                                            <ul>
                                                <li><a href="javascript:void(0)">Our Products</a>
                                                    <ul>
                                                        <li><a href="/stainless-steel-buttweld-fittings">Stainless Steel Fittings</a></li>
                                                        <li><a href="/stainless-steel-flanges">Stainless Steel Flanges</a></li>
                                                        <li><a href="javascript:void()">Stainless Steel Fasteners</a></li>
                                                        <li><a href="javascript:void()">Stainless Steel Sheet</a></li>
                                                        <li><a href="javascript:void()">Stainless Steel Pipe</a></li>
                                                        <li><a href="javascript:void()">Stainless Steel Round Bar</a></li> 
                                                    </ul>
                                                </li>
                                                <li><a href="javascript:void(0)">Specialized Products</a>
                                                    <ul>
                                                        <li><a href="javascript:void();">Duplex Pipe</a></li>
                                                        <li><a href="javascript:void();">Duplex Flanges</a></li>
                                                        <li><a href="javascript:void();">Duplex Steel Fittings</a></li>
                                                        <li><a href="javascript:void();">Duplex Steel Plate</a></li>
                                                        <li><a href="javascript:void();">Duplex Steel Round Bar</a></li>
                                                        <li><a href="javascript:void();">Duplex Steel Fasteners</a></li>
                                                    </ul>
                                                </li>
                                            </ul>
                                        </li>
                                        
                                        <li><a href="/quality-policy">Quality Policy</a></li>
                                        <li><a href="/contact">Contact Us</a></li>
                                    </ul>
                                    <!-- end menu area -->
                                    <div class="ml-4 d-none d-lg-inline-block">
                                        <a class="butn style-four small" href="/enquiry">Request a quote</a>
                                    </div>

                                </nav>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </header>
        <!-- end header section -->

        <?php $__env->startSection('content'); ?>
        <?php echo $__env->yieldSection(); ?>

        <!-- start footer section -->
        <footer class="footer-style3 bg-white bg-img cover-background" data-background="<?php echo e(asset('/img/bg/footer.png')); ?>">
            <div class="container lg-container">
                <div class="footer-5">
                    <div class="row">
                        <div class="col-lg-5 col-md-6 mb-5 mb-lg-0">
                            <span class="footer-logo mb-1-6 d-inline-block">
                                <img src="<?php echo e(asset('/img/logos/rm_logo_white.png')); ?>" alt="logo">
                            </span>
                            <p>
                                REHAN METALS <br>
                                66/68 SHREE RAM BHAVAN GROUND FLOOR NO. 4 <br>
                                4TH KUMBHARWADA MUMBAI 400004 <br><br>
                                <span class="font-weight-700 text-white">MR. DINESH PRAJAPAT</span>
                            </p>
                            <ul>
                                <li><a href="mailto:metalsrehan@gmail.com">metalsrehan@gmail.com</a></li>
                                <li><a href="tel:+919321219021">+91 9321219021</a></li>
                                <li><a href="tel:+919920702910">+91 9920702910</a></li>
                            </ul>
                            <div class="footer-icon">
                                <ul class="mb-0">
                                    <li>
                                        <a href="#!"><i class="fab fa-facebook-f"></i></a>
                                    </li>
                                    <li>
                                        <a href="#!"><i class="fab fa-twitter"></i></a>
                                    </li>
                                    <li>
                                        <a href="#!"><i class="fab fa-dribbble"></i></a>
                                    </li>
                                    <li>
                                        <a href="#!"><i class="fab fa-linkedin-in"></i></a>
                                    </li>
                                </ul>
                            </div>
                        </div>

                        <div class="col-lg-3 col-md-6 mb-5 mb-md-0">
                            <h3>Our Products</h3>
                            <ul class="mb-0">
                                <li><a href="/stainless-steel-buttweld-fittings">Stainless Steel Fitting</a></li>
                                <li><a href="/stainless-steel-flanges">Stainless Steel Flanges</a></li>
                                <li><a href="#!">Stainless Steel Fasteners</a></li>
                                <li><a href="#!">Stainless Steel Sheet</a></li>
                                <li><a href="#!">Stainless Steel Pipe</a></li>
                                <li><a href="#!">Stainless Steel Round Bar</a></li>

                            </ul>
                        </div>

                        <div class="col-lg-3 col-md-6">
                            <h3>Special Products</h3>
                            <ul class="mb-0">
                                <li><a href="#!">Duplex Pipe</a></li>
                                <li><a href="#!">Duplex Flanges</a></li>
                                <li><a href="#!">Duplex Steel Fittings</a></li>
                                <li><a href="#!">Duplex Steel Plate</a></li>
                                <li><a href="#!">Duplex Steel Round Bar</a></li>
                                <li><a href="#!">Duplex Steel Fasteners</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <div class="footer-style3-bottom">
                <div class="container">
                    <p>&copy;
                        <script>
                            document.write(new Date().getFullYear())
                        </script> Copyright | Design and developed by<a href="http://thevikram.ga" target="_blank" class="font-weight-700"> Vikram</a></p>
                </div>
            </div>
        </footer>
        <!-- end footer section -->

    </div>
    <!-- end main-wrapper section -->
	

	<!-- start scroll to top -->
    <a href="javascript:void(0)" class="scroll-to-top"><i class="fas fa-angle-up" aria-hidden="true"></i></a>
    <!-- end scroll to top -->

    <!-- all js include start -->

    <!-- jquery -->
    <script src="<?php echo e(asset('/js/core.min.js')); ?>"></script>

    <!-- custom scripts -->
    <script src="<?php echo e(asset('/js/main.js')); ?>"></script>
    <!-- all js include end -->
</body>
</html><?php /**PATH C:\xampp\htdocs\laravel\RehanMetals\RehanMetals\resources\views/layouts/main_layout.blade.php ENDPATH**/ ?>